<?php
/*
Plugin Name: Google search shortcode
Version: 0.1
Plugin URI: http://matrafox.info/google-search-shortcode.html
Author: Onofrei Radu
Author URI: http://www.matrafox.info
Description: You can add post to your database from what user search
*/

// Avoid name collisions.
if  (!class_exists ('GoogleInsert')):

class GoogleInsert
{
	// name for our options in the DB
	var $db_option = 'GooglInsert_options';
	var $plugin_domain='GoogleInsert';
	// the plugin URL
	var $plugin_url;


	function GoogleInsert()
	{

		$local_pages = array('plugins.php','post-new.php','edit.php');
		if (in_array($pagenow,$local_pages))
		{
			$this->handle_load_domain();
		}
		global $wp_version;
		$exit_msg=__('Google search Insert for WordPress requires WordPress 2.6 or newer. <a href="http://codex.wordpress.org/Upgrading_WordPress">Please update!</a>',$this->plugin_domain);
		if (version_compare($wp_version, "2.6", "<"))
		{
			exit ($exit_msg);
		}

		$this->plugin_url= trailingslashit(WP_PLUGIN_URL.'/'.dirname( plugin_basename(__FILE__)));

		add_shortcode('googleSinsert', array(&$this, 'display'));
		add_action('admin_menu', array(&$this, 'admin_menu'));
		$plugin = plugin_basename(__FILE__);
		add_filter("plugin_action_links_$plugin", array($this, 'your_plugin_settings_link'));
		add_filter('widget_text', 'do_shortcode');

	}
	function admin_menu()
	{
		global $user_level;
		get_currentuserinfo();
		if ($user_level < 10)
		{
			return;
		}
		add_options_page(__('Google Search Shortcode',$this->plugin_domain), __('Google Shortcode',$this->plugin_domain),8, basename(__FILE__), array(&$this, 'handle_options'));
	}
	function your_plugin_settings_link($links)
	{
		$settings_link = '<a href="options-general.php?page=google-search-insert.php">'.__('Settings',$this->plugin_domain).'</a>';
		array_unshift($links, $settings_link);
		return $links;
	}


	function display($params, $content = null )
	{	//this function is for shortcode



		if (wp_verify_nonce($_POST['GoogleInsert-nonce'],'GoogleInsert'))
		{
			//if we came from search button execute bellow
			$havetosearch = isset($_POST['publish']);
			if ($havetosearch && $_POST['google-search'] != '')
			{
				// get default options from db settings
				$options = get_option("$this->db_option");
				$word=$_POST['google-search'];
				$query=urlencode($word);
				$key = $options['key'];
				$hl = $options['hl'];


				$Gresult = __('Search results for:',$this->plugin_domain).' '.$query.'<br />-----<br />';
				$res = $this->google_search_api(array('q' => $query,'key' => $key,'hl' => $hl));
				/*echo "<pre>";
				print_r($res);
				echo "</pre>";*/
				$pages=$res['responseData']['cursor']['pages'];
				$nres=0;
				//var $Gresult;

				for($i=0;$i<count($pages);$i++)
				{
					$res = $this->google_search_api(array('q' => $query,'key' => $key,'hl' => $hl,'start'=>$res['responseData']['cursor']['pages'][$i]['start']));
					for($j=0;$j<count($res['responseData']['results']); $j++)
					{
						if( $nres == $options['rows'])
						{ 	$ex = true;
						break;
						}
						$nres++;
						//echo
						$Gresult .= '</br><a href="'.
						urldecode($res['responseData']['results'][$j]['url']).'">'.$res['responseData']['results'][$j]['title'].'</a></br>'.
						$res['responseData']['results'][$j]['content'];
						//echo "</br>".$Gresult;

					}


				}

				$Gresult .= '<br />---<br />'.__('Total number of reuslts:',$this->plugin_domain).' '. $nres;

			}

			//end nonce
		}
		ob_start();
		include( 'template/google.php');
		$output = ob_get_contents();
		ob_end_clean();
		$out=$content.$output.$Gresult;

		return $out;
	}
	function google_search_api($args, $referer = 'http://localhost/', $endpoint = 'web')
	{
		//this function search into google using the api from them

		$url = "http://ajax.googleapis.com/ajax/services/search/".$endpoint;

		if ( !array_key_exists('v', $args) )
		$args['v'] = '1.0';
		$args['userip']=$_SERVER['REMOTE_ADDR'];
		$args['rsz']='8';
		$url .= '?'.http_build_query($args, '', '&');
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		// note that the referer *must* be set
		curl_setopt($ch, CURLOPT_REFERER, $referer);
		$body = curl_exec($ch);
		curl_close($ch);
		//decode and return the response
		return json_decode($body,true);
	}
	function get_options()
	{
		//default values
		$options = array
		(

		'key' => '',
		'hl' => 'en',
		'rows' => '10'
		);
		//get saved options
		$saved = get_option($this->db_option);
		// assign them
		if (!empty($saved))
		{
			foreach ($saved as $key => $option)

			$options[$key]= $option;
		}
		// update the options if necessary
		if ($saved != $options)
		update_option($this->db_option, $options);
		return $options;
	}

	function handle_options()
	{
		$options = $this->get_options();
		if (isset($_POST['submitted']))
		{
			//check security
			check_admin_referer('GoogleInsert-nonce');
			$options= array();
			$options['key']= htmlspecialchars($_POST['GoogleInsert-key']);
			$options['rows']=(int) $_POST['GoogleInsert-rows'];
			$options['hl'] = $_POST['GoogleInsert-hl'];
			if ($options['rows'] <= 0 or $options['rows'] >=64 )
			$options['rows'] = 10;
			if (strlen($options['hl']) != 2)
			$options['hl'] = 'en';
			update_option($this->db_option,$options);
			echo '<div class="updated fade"><p>'.__('Plugin settings saved.',$this->plugin_domain).'</p></div>';
		}
		$key=$options['key'];
		$rows=$options['rows'];
		$hl=$options['hl'];
		// URL for form submit, equals our current page
		$action_url = $_SERVER['REQUEST_URI'];
		include('template/options.tpl.php');

	}


	function handle_load_domain()
	{
		// get current language
		$locale = get_locale();
		//locate translation fiel
		$mofile = WP_PLUGIN_DIR.'/'.plugin_basename(dirname(__FILE__)).'/lang/'.$this->plugin_domain.'-'.$locale.'.mo';
		// load translation
		load_textdomain($this->plugin_domain,$mofile);
	}
	// Set up everything
	function install()
	{
	}
}
endif;
if ( class_exists ('GoogleInsert')):
$GoogleInsert = new GoogleInsert();
if (isset ($GoogleInsert))
{
	register_activation_hook(__FILE__,array(&$GoogleInsert,'install'));
}
endif;


?>